Scriptname _slsubmitautosurrenderhiteffect extends activemagiceffect  

_SLSubmitQuest Property _SLQuest Auto
_SLSubmitFunctions Property _SLFunctions Auto
_SLSubmitConfig Property _SLConfig Auto
_SLSubmitScene Property _SLScene Auto
Float Property ChanceSpan Auto
Float Property HealthSpan Auto
Float Property ChancePoint Auto
GlobalVariable Property SuccessChance  Auto  
GlobalVariable Property SuccessRoll  Auto  
GlobalVariable Property _SLSubmitSurrenderGlobal  Auto
GlobalVariable Property _SLSubmitHardcoreBindings Auto
SPELL Property _SLSubmitAssign  Auto  
Race Property Werewolf Auto
Actor Property PlayerRef Auto
Race DLC1VampireBeast

;==================================
;Events functions
;==================================
Event OnEffectStart(Actor akTarget, Actor akCaster)
	If (_SLQuest.Dawnguard)
		DLC1VampireBeast = Game.GetFormFromFile(0x283A, "Dawnguard.esm") as Race
	EndIf
EndEvent

Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
	If (!_SLQuest.Brawling)
		float health = PlayerRef.GetAV("Health")/PlayerRef.GetBaseAV("Health")
		If (_SLConfig.modActive && (health < (_SLConfig.AutoSubmit)) && PlayerRef.GetRace() != Werewolf && PlayerRef.GetRace() != DLC1VampireBeast && !PlayerRef.IsOnMount() && _SLSubmitSurrenderGlobal.GetValue() == 0 && _SLSubmitHardcoreBindings.GetValue() == 0)
			ChanceSpan = 100 - _SLConfig.AutoSubmitChance
			HealthSpan = _SLConfig.AutoSubmit - health
			ChancePoint = ChanceSpan / _SLConfig.AutoSubmit
			SuccessChance.SetValue(_SLConfig.AutoSubmitChancePercent + ChancePoint * HealthSpan)
			If (SuccessChance.GetValue() > 100.0)
				SuccessChance.SetValue(100.0)
			EndIf
			SuccessRoll.SetValue(Utility.RandomInt(0, 100))
			If ( SuccessChance.GetValue() > SuccessRoll.GetValue())
				_SLFunctions.ClearAssailants()
				_SLSubmitSurrenderGlobal.SetValue(1)
				_SLSubmitAssign.Cast(PlayerRef)
				_SLFunctions.Surrender()
			EndIf
		EndIf
	EndIf
EndEvent
